﻿#region << Using Directives >>
using System;
#endregion

namespace Volpe.Cafe.Generic
{
    /// <summary>
    /// Represents an object that stores compliance modeling data for each fuel type. This object supports deep member cloning by
    /// requiring that each variable of this generic class implement the <see cref="ICloneable"/> interface.
    /// </summary>
    [Serializable]
    public class FTObject<T> : FTValue<T>, ICloneable where T : ICloneable
    {

        #region /*** Ctors ***/

        /// <summary>
        /// Initializes a new instance of the <see cref="FTObject{T}"/> class.
        /// </summary>
        public FTObject() : base() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="FTObject{T}"/> class using the specified values.
        /// </summary>
        public FTObject(T gasoline, T ethanol85, T diesel, T electricity, T hydrogen, T cng)
            : base(gasoline, ethanol85, diesel, electricity, hydrogen, cng) { }

        #endregion

        #region /*** Methods ***/

        #region /* ICloneable Members */

        /// <summary>
        /// Creates a copy of the current <see cref="FTObject{T}"/> instance.
        /// </summary>
        /// <returns>A new object that is a copy of this <see cref="FTObject{T}"/>.</returns>
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        /// <summary>
        /// Creates a copy of the current <see cref="FTObject{T}"/> instance.
        /// </summary>
        /// <returns>A new object that is a copy of this <see cref="FTObject{T}"/>.</returns>
        public new FTObject<T> Clone()
        {
            FTObject<T> value = new FTObject<T>();
            this.CopyTo(value);
            return value;
        }
        /// <summary>
        /// Copies the members of the current <see cref="FTObject{T}"/> instance into the specified value.
        /// </summary>
        /// <param name="value">The value where to copy the members of the current instance.</param>
        protected void CopyTo(FTObject<T> value)
        {
            for (int i = 0; i < this.Items.Length; i++)
            {
                value.Items[i] = (T)this.Items[i].Clone();
            }
        }

        #endregion

        #endregion

    }
}
